#include "LPC15xx.h"

extern void SCT0_Init(void);

void SCT0_IRQHandler(void)
{
  uint32_t status = LPC_SCT0->EVFLAG;

    if (status & 1)                                    // EVENT 0: timeout
    {
		/* New measurement result */
		;
    }

    if (status & (1 << 5))                             // EVENT 5: width error
    {
		/* Time-out (no signal) */
		;
    }
    LPC_SCT0->EVFLAG = status;                         // Acknowledge interrupts
}

int main (void)
{
  volatile static int i = 0;                           // force counter to be placed into memory

    LPC_SYSCON->SYSAHBCLKCTRL0 |= EN0_SWM    |         // enable SWM clock
                                  EN0_GPIO0  |         // enable GPIO port 0 clock
                                  EN0_GPIO1  |         // enable GPIO port 1 clock
                                  EN0_P_MUX  |         // enable PMUX clock
                                  EN0_IOCON;           // enable IOCON clock

    LPC_SWM->PINASSIGN7        |= 0x00FFFF00;          // ASSIGN7(23:8) = FFFF
    LPC_SWM->PINASSIGN7        &= 0xFF1800FF;          // SCT0_OUT0 = P0.0  = timeout (red LED)
                                                       // SCT0_OUT1 = P0.24 = width_error (green LED)
    LPC_PMUX->SCT0_P_MUX0       = 2;                   // SCT0_IN2  = P0.17 = SW1

    SCT0_Init();                                       // Initialize SCT0

    while (1)                                          // loop forever
    {
       	/* The settings are chosen in % of duty cycle (assuming a PWM frequency of 10 kHz).
       	 * (In a real world application you want to select better resolution!)
       	 */
        i = LPC_SCT0->CAP[4].U;
    }
}
